##Direct effect

set.seed(1)

N1 = 1000
propensity = 0.5
g = (0.8784588246288023 + 0.8558211723399304) / 2
n = 10000
tauhatDIRs = NULL
tauhatHajs = NULL


for (ii in 1:N1){
  W = rbinom(n,1,propensity)
  Gu1u2 = matrix(rep(g,n^2),ncol = n)
  diag(Gu1u2) = rep(0,n)
  edge = matrix(runif(n^2), ncol = n) < Gu1u2
  edge.diag = diag(edge)
  edge[lower.tri(edge,diag=T)] = 0
  edge = edge + t(edge)
  
  Ni = apply(edge,2,sum)
  Mi = apply(edge*W,2,sum)
  
  prop = Mi/pmax(1,Ni)
  y = 1/2000*(0.5*(0.315 + 0.079 * W)/(1+0.197*prop*g+0.5*0.315*0.86714*(1-prop))+0.5*0.315/(1+0.5*0.315*g))

  tauhatDIR = mean(y*W/propensity - y*(1-W)/(1-propensity))
  tauhatHaj = mean(y*W/mean(W) - y*(1-W)/(1-mean(W)))
  tauhatDIRs = c(tauhatDIRs, tauhatDIR)
  tauhatHajs = c(tauhatHajs, tauhatHaj)
  print(ii)
}
mean(tauhatDIRs)
mean(tauhatHajs)

png(filename = "histograms.png", width = 800, height = 400)

par(mfrow = c(1, 2))

hist(tauhatDIRs, main = "Histogram of tauhatDIRs", xlab = "tauhatDIRs")

hist(tauhatHajs, main = "Histogram of tauhatHajs", xlab = "tauhatHajs")

dev.off()

